/**
 * \file: libsugc_log.h
 *
 * \brief : Defines to log debug information and error messages
 *
 * \author: Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2017 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#ifndef LIBSUGC_LOG
#define LIBSUGC_LOG

#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>

/**
 * \defgroup libsugc_log_api libsugc internal API used for log and error messages
 */

#ifdef ENABLE_DEBUG_LOGS
    /**
     * \ingroup libsugc_log_api
     * \brief Log debug message - to allow following the execution path
     */
    #define LIBSUGC_DEBUG(msgformat,...)    syslog(LOG_DEBUG,"LIBSUGC_DEBUG:"msgformat"\n", ## __VA_ARGS__)
#else
    /**
     * \ingroup libsugc_log_api
     * \brief Log debug message - to allow following the execution path
     */
    #define LIBSUGC_DEBUG(msgformat,...)    {}
#endif

/**
 * \ingroup libsugc_log_api
 * \brief Log info message - e.g. used user, group
 */
#define LIBSUGC_INFO(msgformat,...)     syslog(LOG_INFO,"LIBSUGC_INFO:"msgformat"\n", ## __VA_ARGS__)

/**
 * \ingroup libsugc_log_api
 * \brief Log error message
 */
#define LIBSUGC_ERROR(msgformat,...)    syslog(LOG_CRIT,"LIBSUGC_ERR:"msgformat"\n", ## __VA_ARGS__)

#endif
